/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.bonus.dto;

import java.util.Date;

import jp.mosp.common.common.BaseDto;

public class PhBasisDto extends BaseDto {

	private static final long serialVersionUID = 3115468966868261668L;
	
	// tB[h
	private String kCode          ;	// ЈR[h
	private Date   expectedDate   ;	// Kp\
	private Date   appliedDate    ;	// Kp
	private String kName          ;	// Ј
	private String kKana          ;	// Јض
	private String stationCode    ;	// R[h
	private String positionCode   ;	// EʃR[h
	private String employmentType ;	// ٗp敪
	private Date   entranceDate   ;	// Г
	private Date   appointmentDate;	// op
	private Date   retirementDate ;	// ގГ
	
	private String missingInput  ;	// Wv
	private String changing      ;	// ύXe
	
	/**
	 * RXgN^
	 */
	public PhBasisDto() {
		super();
	}
	
	// ANZT\bh
	public String getKCode          () { return kCode                        ; }	// ЈR[h
	public Date   getExpectedDate   () { return getDateField(expectedDate)   ; }	// Kp\
	public Date   getAppliedDate    () { return getDateField(appliedDate)    ; }	// Kp
	public String getKName          () { return kName                        ; }	// Ј
	public String getKKana          () { return kKana                        ; }	// Јض
	public String getStationCode    () { return stationCode                  ; }	// R[h
	public String getPositionCode   () { return positionCode                 ; }	// EʃR[h
	public String getEmploymentType () { return employmentType               ; }	// ٗp敪
	public Date   getEntranceDate   () { return getDateField(entranceDate   ); }	// Г
	public Date   getAppointmentDate() { return getDateField(appointmentDate); }	// op
	public Date   getRetirementDate () { return getDateField(retirementDate ); }	// ގГ
	public void setKCode          (String kCode          ) { this.kCode           = kCode                        ; }	// ЈR[h
	public void setExpectedDate   (Date   expectedDate   ) { this.expectedDate    = getDateField(expectedDate)   ; }	// Kp\
	public void setAppliedDate    (Date   appliedDate    ) { this.appliedDate     = getDateField(appliedDate)    ; }	// Kp
	public void setKName          (String kName          ) { this.kName           = kName                        ; }	// Ј
	public void setKKana          (String kKana          ) { this.kKana           = kKana                        ; }	// Јض
	public void setStationCode    (String stationCode    ) { this.stationCode     = stationCode                  ; }	// R[h
	public void setPositionCode   (String positionCode   ) { this.positionCode    = positionCode                 ; }	// EʃR[h
	public void setEmploymentType (String employmentType ) { this.employmentType  = employmentType               ; }	// ٗp`
	public void setEntranceDate   (Date   entranceDate   ) { this.entranceDate    = getDateField(entranceDate   ); }	// Г
	public void setAppointmentDate(Date   appointmentDate) { this.appointmentDate = getDateField(appointmentDate); }	// op
	public void setRetirementDate (Date   retirementDate ) { this.retirementDate  = getDateField(retirementDate ); }	// ގГ
	
	public String getMissingInput() { return missingInput; }
	public void setMissingInput(String missingInput) { this.missingInput = missingInput; }
	public String getChanging() { return changing; }	// ύXe
	public void setChanging(String changing) { this.changing = changing; }	// ύXe
	

}
